-- Enhanced Vanilla
-- A 3Ra Gaming compilation
-- config and event must be required first.
require "util"
require "locale/utils/event"
require "config"
require "locale/utils/utils"
require "score"

require "locale/utils/player-list"
require "locale/utils/game-info"
require "showhealth"
require "poll"

require "announcements"
require "tag"
--require "locale/mapsettings/resources"

-- Give player starting items.
-- @param event on_player_joined event
function player_joined(event)
	local player = game.players[event.player_index]
	player.insert { name = "iron-plate", count = 10 }
	player.insert { name = "pistol", count = 1 }
	player.insert { name = "firearm-magazine", count = 10 }
	end

-- Give player weapons after they respawn.
-- @param event on_player_respawned event
function player_respawned(event)
	local player = game.players[event.player_index]
	player.insert { name = "pistol", count = 1 }
	player.insert { name = "firearm-magazine", count = 10 }
end

Event.register(defines.events.on_research_finished, function (event)
	local research = event.research
	if global.scenario.config.logistic_research_enabled then
		research.force.technologies["logistic-system"].enabled=true
	else
	        research.force.technologies["logistic-system"].enabled=false
	end
end)


-- Event handlers
Event.register(defines.events.on_player_created, player_joined)
Event.register(defines.events.on_player_respawned, player_respawned)
